/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import net.adventurez.entity.nonliving.AmethystShardEntity;
import net.adventurez.init.ParticleInit;
import net.adventurez.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class AmethystGolemEntity
extends Monster {
    public static final EntityDataAccessor<Integer> BACK_CRYSTALS = SynchedEntityData.m_135353_(AmethystGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> DEEPSLATE_VARIANT = SynchedEntityData.m_135353_(AmethystGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int grow = 0;
    private boolean isStronger = false;

    public AmethystGolemEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
    }

    public static AttributeSupplier.Builder createAmethystGolemAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22279_, 0.24).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22284_, 1.0);
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.85, false));
        this.f_21345_.m_25352_(2, (Goal)new ThrowShardGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.9));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static boolean canSpawn(EntityType<AmethystGolemEntity> type, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return AmethystGolemEntity.m_219013_(type, (ServerLevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random) && !world.m_45527_(pos) || spawnReason == MobSpawnType.SPAWNER;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BACK_CRYSTALS, (Object)4);
        this.f_19804_.m_135372_(DEEPSLATE_VARIANT, (Object)false);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(BACK_CRYSTALS, (Object)tag.m_128451_("Crystals"));
        this.f_19804_.m_135381_(DEEPSLATE_VARIANT, (Object)tag.m_128471_("DeepslateGolem"));
        this.grow = tag.m_128451_("GrowAmethysts");
        this.isStronger = tag.m_128471_("StrongerGolem");
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Crystals", ((Integer)this.f_19804_.m_135370_(BACK_CRYSTALS)).intValue());
        tag.m_128379_("DeepslateGolem", ((Boolean)this.f_19804_.m_135370_(DEEPSLATE_VARIANT)).booleanValue());
        tag.m_128405_("GrowAmethysts", this.grow);
        tag.m_128379_("StrongerGolem", this.isStronger);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && (Integer)this.f_19804_.m_135370_(BACK_CRYSTALS) < 4) {
            ++this.grow;
            if (this.grow >= 3600) {
                this.f_19804_.m_135381_(BACK_CRYSTALS, (Object)((Integer)this.f_19804_.m_135370_(BACK_CRYSTALS) + 1));
                this.m_21051_(Attributes.f_22276_).m_22100_(this.m_21172_(Attributes.f_22276_) + 10.0);
                this.m_5634_(10.0f);
                this.grow = 0;
            }
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityTag) {
        int random = this.m_217043_().m_188503_(5);
        this.f_19804_.m_135381_(BACK_CRYSTALS, (Object)random);
        if (random > 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(this.m_21172_(Attributes.f_22276_) + (double)random * 10.0);
        }
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityTag);
    }

    public boolean m_6785_(double distanceSquared) {
        return false;
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
    }

    protected SoundEvent m_7515_() {
        return SoundInit.AMETHYST_GOLEM_IDLE_EVENT;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundInit.AMETHYST_GOLEM_HIT_EVENT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.AMETHYST_GOLEM_DEATH_EVENT;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundInit.AMETHYST_GOLEM_WALK_EVENT, 0.9f, 1.0f);
    }

    public void amethystGolemRageMode() {
        if (this.m_9236_() instanceof ServerLevel) {
            this.m_21051_(Attributes.f_22284_).m_22100_(this.m_21172_(Attributes.f_22284_) + 2.0);
            if (!this.isStronger) {
                this.m_21051_(Attributes.f_22279_).m_22100_(this.m_21172_(Attributes.f_22279_) + 0.1);
            }
            ((ServerLevel)this.m_9236_()).m_6269_(null, (Entity)this, SoundInit.AMETHYST_GOLEM_RAGE_EVENT, SoundSource.HOSTILE, 1.0f, 1.0f);
            for (int i = 0; i < 20; ++i) {
                double d = this.m_20185_() - 1.0 + (double)(this.m_9236_().m_213780_().m_188501_() * 2.0f);
                double e = (float)this.m_20187_() + this.m_9236_().m_213780_().m_188501_() * 0.1f;
                double f = this.m_20189_() - 1.0 + (double)(this.m_9236_().m_213780_().m_188501_() * 2.0f);
                double g = (double)this.m_9236_().m_213780_().m_188501_() * 0.4;
                double h = (double)this.m_9236_().m_213780_().m_188501_() * 0.2;
                double l = (double)this.m_9236_().m_213780_().m_188501_() * 0.4;
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleInit.AMETHYST_SHARD_PARTICLE, d, e, f, 4, g, h, l, 1.0);
            }
            this.isStronger = true;
        }
    }

    public class ThrowShardGoal
    extends Goal {
        private final AmethystGolemEntity amethystGolemEntity;
        private int cooldown;
        private long lastUpdateTime;

        public ThrowShardGoal(AmethystGolemEntity amethystGolemEntity) {
            this.amethystGolemEntity = amethystGolemEntity;
        }

        public boolean m_8036_() {
            long l = this.amethystGolemEntity.m_9236_().m_46467_();
            if (l - this.lastUpdateTime < 100L || this.cooldown-- > 0) {
                return false;
            }
            this.lastUpdateTime = l;
            LivingEntity livingEntity = this.amethystGolemEntity.m_5448_();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.m_6084_()) {
                return false;
            }
            return this.amethystGolemEntity.m_142582_((Entity)livingEntity);
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = this.amethystGolemEntity.m_5448_();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.m_6084_()) {
                return false;
            }
            if (!this.amethystGolemEntity.m_21444_(livingEntity.m_20183_()) || !this.amethystGolemEntity.m_142582_((Entity)livingEntity)) {
                return false;
            }
            if (this.cooldown > 0) {
                return false;
            }
            return !(livingEntity instanceof Player) || !livingEntity.m_5833_() && !((Player)livingEntity).m_7500_();
        }

        public void m_8056_() {
            this.amethystGolemEntity.m_6674_(InteractionHand.MAIN_HAND);
            if (!this.amethystGolemEntity.m_9236_().m_5776_()) {
                ((ServerLevel)this.amethystGolemEntity.m_9236_()).m_6269_(null, (Entity)this.amethystGolemEntity, SoundInit.ROCK_THROW_EVENT, SoundSource.HOSTILE, 0.74f, 1.0f);
                AmethystShardEntity amethystShardEntity = new AmethystShardEntity((LivingEntity)this.amethystGolemEntity, this.amethystGolemEntity.m_9236_());
                amethystShardEntity.m_37251_((Entity)this.amethystGolemEntity, this.amethystGolemEntity.m_146909_(), this.amethystGolemEntity.m_146908_(), -20.0f, 0.7f, 1.0f);
                this.amethystGolemEntity.m_9236_().m_7967_((Entity)amethystShardEntity);
            }
            this.cooldown = 80 + this.amethystGolemEntity.m_217043_().m_188503_(200);
            this.m_8041_();
        }
    }
}

